/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.display;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.impactdev.impactor.api.scoreboards.AssignedScoreboard;
import net.impactdev.impactor.api.scoreboards.ScoreboardRenderer;
import net.impactdev.impactor.api.scoreboards.display.Display;
import net.impactdev.impactor.api.scoreboards.display.Displayable;
import net.impactdev.impactor.api.scoreboards.display.text.ScoreboardComponent;
import net.impactdev.impactor.api.scoreboards.updaters.Updater;
import net.impactdev.impactor.api.scoreboards.updaters.UpdaterConfiguration;
import net.impactdev.impactor.core.utility.pointers.AbstractPointerCapable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

public abstract class AbstractDisplay
extends AbstractPointerCapable
implements Display {
    private final AssignedScoreboard scoreboard;
    private final Updater updater;
    private final ScoreboardComponent component;
    protected final AtomicReference<Component> text = new AtomicReference<TextComponent>(Component.empty());

    protected AbstractDisplay(AssignedScoreboard scoreboard, Displayable displayable) {
        this.scoreboard = scoreboard;
        this.component = displayable.component();
        this.text.set(this.component.resolve(this.scoreboard.viewer()));
        this.updater = Optional.ofNullable(displayable.updater()).map(UpdaterConfiguration::generate).orElse(null);
    }

    @Override
    public Component text() {
        return this.text.get();
    }

    @Override
    public Updater updater() {
        return this.updater;
    }

    protected abstract void render(AssignedScoreboard var1, ScoreboardRenderer var2);

    protected void onTick(AssignedScoreboard scoreboard) {
    }

    @Override
    public void tick() {
        this.text.set(this.component.resolve(this.scoreboard.viewer()));
        this.onTick(this.scoreboard);
        this.render(this.scoreboard, this.scoreboard.configuration().renderer());
    }
}

